/*
 * Decompiled with CFR 0.152.
 */
package me.anutley.dislink.common;

import java.io.File;
import me.anutley.dislink.common.config.ChannelsConfig;
import me.anutley.dislink.common.config.ConfigLoader;
import me.anutley.dislink.common.config.ConfigManager;
import me.anutley.dislink.common.config.GlobalSettingsConfig;
import me.anutley.dislink.common.config.MainConfig;
import me.anutley.dislink.common.listener.MessageListener;
import me.anutley.dislink.common.logger.DisLinkLogger;
import me.anutley.dislink.common.util.SettingsUtil;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.cache.CacheFlag;

public class DisLink {
    private final ConfigManager configManager;
    private final DisLinkLogger logger;
    private final File dataFolder;
    private final ConfigLoader configLoader;
    private final JDA jda;
    private final SettingsUtil settingsUtil;

    public DisLink(DisLinkLogger logger, File dataFolder) {
        this.logger = logger;
        this.dataFolder = dataFolder;
        this.configLoader = new ConfigLoader(this);
        this.configManager = new ConfigManager(this.configLoader.load(MainConfig.class, "main.conf"), this.configLoader.load(ChannelsConfig.class, "channels.conf"), this.configLoader.load(GlobalSettingsConfig.class, "global-settings.conf"));
        this.jda = JDABuilder.createDefault(this.configManager.mainConfig().botToken()).setEnabledIntents(GatewayIntent.GUILD_MEMBERS, GatewayIntent.GUILD_MESSAGES, GatewayIntent.GUILD_EMOJIS_AND_STICKERS, GatewayIntent.MESSAGE_CONTENT).disableCache(CacheFlag.VOICE_STATE, CacheFlag.SCHEDULED_EVENTS).addEventListeners(new MessageListener(this)).build();
        this.settingsUtil = new SettingsUtil(this);
    }

    public DisLinkLogger logger() {
        return this.logger;
    }

    public File dataFolder() {
        return this.dataFolder;
    }

    public ConfigLoader configLoader() {
        return this.configLoader;
    }

    public ConfigManager configManager() {
        return this.configManager;
    }

    public JDA jda() {
        return this.jda;
    }

    public SettingsUtil settingsUtil() {
        return this.settingsUtil;
    }

    public void debug(String message) {
        if (this.configManager.mainConfig().debug()) {
            this.logger.debug(message);
        }
    }
}

