/*
 * Decompiled with CFR 0.152.
 */
package me.anutley.dislink.common.config;

import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;

@ConfigSerializable
public class SettingsConfig {
    @Comment(value="Available placeholders can be found in the GitHub README file\n")
    private MessagesConfig messages = new MessagesConfig();
    @Comment(value="")
    private IgnoreConfig ignore = new IgnoreConfig();
    @Comment(value="")
    private MentionsConfig mentions = new MentionsConfig();

    @ConfigSerializable
    public static class MessagesConfig {
        @Comment(value="Settings relating the webhook delivery method")
        private WebhookConfig webhooks = new WebhookConfig();
        @Comment(value="Settings relating the webhook plaintext method")
        private PlainTextConfig plaintext = new PlainTextConfig();

        @ConfigSerializable
        public static class WebhookConfig {
            @Comment(value="")
            private String usernameFormat = "[DisLink] %author_displayname%";
            @Comment(value="")
            private String messageFormat = "%message%";
            @Comment(value="")
            private String avatarUrl = "%author_avatar%";
        }

        @ConfigSerializable
        public static class PlainTextConfig {
            @Comment(value="")
            private String messageFormat = "%author_displayname% > %message%";
        }
    }

    @ConfigSerializable
    public static class IgnoreConfig {
        @Comment(value="Whether messages sent from bots should be ignored")
        boolean bots = false;
        @Comment(value="Whether messages sent from webhooks should be ignored")
        boolean webhooks = false;
        @Comment(value="Whether embeds should be ignored")
        boolean embeds = false;
        @Comment(value="Whether attachments from bots should be ignored")
        boolean attachments = false;
    }

    @ConfigSerializable
    public static class MentionsConfig {
        @Comment(value="Whether @user mentions should be parsed")
        boolean user = true;
        @Comment(value="Whether @role mentions should be parsed. WARNING: enabling this will allow users to ping any role using the bridge")
        boolean role = false;
        @Comment(value="Whether @everyone should be parsed. WARNING: enabling this will allow users to ping @everyone using the bridge")
        boolean everyone = false;
    }
}

