/*
 * Decompiled with CFR 0.152.
 */
package me.anutley.dislink.common.delivery.message;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.anutley.dislink.common.delivery.sender.MessageSender;
import net.dv8tion.jda.api.entities.MessageEmbed;

public abstract class DisLinkMessageBuilder<M> {
    protected MessageSender<?, ?> sender;
    private String content = "";
    private final List<MessageEmbed> embeds = new ArrayList<MessageEmbed>();
    private final Map<String, List<InputStream>> attachments = new HashMap<String, List<InputStream>>();

    public DisLinkMessageBuilder(MessageSender<?, ?> sender) {
        this.sender = sender;
    }

    public abstract M build();

    public String content() {
        return this.content;
    }

    public void content(String content) {
        this.content = content;
    }

    public List<MessageEmbed> embeds() {
        return this.embeds;
    }

    public void addEmbed(MessageEmbed embed) {
        this.embeds.add(embed);
    }

    public Map<String, List<InputStream>> attachments() {
        return this.attachments;
    }

    public void addFile(String name, InputStream inputStream2) {
        this.attachments.computeIfAbsent(name, n -> new ArrayList()).add(inputStream2);
    }
}

