/*
 * Decompiled with CFR 0.152.
 */
package me.anutley.dislink.common.delivery.sender;

import club.minnced.discord.webhook.WebhookClientBuilder;
import club.minnced.discord.webhook.receive.ReadonlyMessage;
import club.minnced.discord.webhook.send.AllowedMentions;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import me.anutley.dislink.common.DisLink;
import me.anutley.dislink.common.config.ChannelPairConfig;
import me.anutley.dislink.common.config.ChannelsConfig;
import me.anutley.dislink.common.delivery.message.DisLinkWebhookMessageBuilder;
import me.anutley.dislink.common.delivery.sender.MessageSender;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.entities.channel.attribute.IWebhookContainer;
import net.dv8tion.jda.api.exceptions.ErrorResponseException;
import net.dv8tion.jda.api.requests.ErrorResponse;

public class WebhookSender
extends MessageSender<WebhookClientBuilder, DisLinkWebhookMessageBuilder> {
    private final String DISLINK_BRIDGE_WEBHOOK_NAME = "Dislink Bridge Webhook";

    public WebhookSender(DisLink disLink, ChannelPairConfig pairConfig, ChannelPairConfig.ChannelConfig originChannel, ChannelPairConfig.ChannelConfig destinationChannel, Message message) {
        super(disLink, pairConfig, originChannel, destinationChannel, message);
    }

    @Override
    public CompletableFuture<WebhookClientBuilder> prepare() {
        Matcher webhookMatcher = Webhook.WEBHOOK_URL.matcher(this.originChannel.webhookUrl());
        User author = this.message.getAuthor();
        if (webhookMatcher.matches() && webhookMatcher.group("id").equals(author.getId())) {
            return null;
        }
        IWebhookContainer destChannel = this.destinationChannel().getType().isThread() ? (IWebhookContainer)((Object)this.destinationChannel().asThreadChannel().getParentChannel()) : (IWebhookContainer)((Object)this.destinationChannel());
        return destChannel.retrieveWebhooks().submit().thenApplyAsync(webhooks -> {
            Matcher matcher = Webhook.WEBHOOK_URL.matcher(this.destinationChannel.webhookUrl());
            Optional<Webhook> webhookOptional = webhooks.stream().filter(w -> matcher.matches()).filter(w -> Objects.equals(w.getToken(), matcher.group("token"))).findAny();
            if (webhookOptional.isPresent()) {
                if (this.disLink.configManager().mainConfig().cleanUpOldWebhooks()) {
                    webhooks.stream().filter(webhook -> webhook.getName().equals("Dislink Bridge Webhook")).filter(webhook -> !webhook.getUrl().equals(((Webhook)webhookOptional.get()).getUrl())).forEach(webhook -> webhook.delete().queue());
                }
                return this.createWebhookClientBuilder(this.destinationChannel.webhookUrl());
            }
            if (this.disLink.configManager().mainConfig().cleanUpOldWebhooks()) {
                webhooks.stream().filter(webhook -> webhook.getName().equals("Dislink Bridge Webhook")).forEach(webhook -> webhook.delete().queue());
            }
            if (!this.disLink.configManager().mainConfig().createWebhooksAutomatically()) {
                this.disLink.debug("No webhooks were found, but auto creating webhooks is disabled in the config, aborting message forwarding for " + this.message);
                return null;
            }
            try {
                Webhook webhook2 = (Webhook)destChannel.createWebhook("Dislink Bridge Webhook").complete();
                this.destinationChannel.webhookUrl(webhook2.getUrl());
                this.disLink.configLoader().saveConfig("channels.conf", this.disLink.configLoader().channelNode(), ChannelsConfig.class, this.disLink.configManager().channelsConfig());
                return this.createWebhookClientBuilder(webhook2.getUrl());
            }
            catch (ErrorResponseException errorResponseException) {
                ErrorResponse errorResponse = errorResponseException.getErrorResponse();
                String message = "";
                if (errorResponse == ErrorResponse.MISSING_PERMISSIONS) {
                    message = "DisLink does not have the sufficient permissions to create a webhook, please give DisLink the MANAGE_WEBHOOKS permission";
                } else if (errorResponse == ErrorResponse.MISSING_ACCESS) {
                    message = "DisLink does not have the sufficient access to view this channel, so cannot create a webhook";
                } else if (errorResponse == ErrorResponse.MAX_WEBHOOKS) {
                    message = "This channel has reached the maximum amount of webhooks, please delete some and try again";
                }
                this.disLink.debug(message + ", aborting message forwarding for " + message);
                errorResponseException.printStackTrace();
                return null;
            }
        });
    }

    @Override
    public Long send(WebhookClientBuilder deliveryMethod, DisLinkWebhookMessageBuilder webhookMessageBuilder) throws ExecutionException, InterruptedException {
        if (this.destinationChannel().getType().isThread()) {
            deliveryMethod.setThreadId(Long.parseLong(this.destinationChannel.channelId()));
        }
        return deliveryMethod.build().send(webhookMessageBuilder.build()).get().getId();
    }

    @Override
    public void edit(WebhookClientBuilder deliveryMethod, long messageId, DisLinkWebhookMessageBuilder messageBuilder) {
        deliveryMethod.build().edit(messageId, messageBuilder.build()).thenApplyAsync(ReadonlyMessage::getId);
    }

    @Override
    public DisLinkWebhookMessageBuilder newMessageBuilder() {
        return new DisLinkWebhookMessageBuilder(this);
    }

    @Override
    public String messageSettingKey() {
        return "messages.webhooks.message-format";
    }

    private WebhookClientBuilder createWebhookClientBuilder(String webhookUrl) {
        return new WebhookClientBuilder(webhookUrl).setAllowedMentions(this.allowedMentions());
    }

    public AllowedMentions allowedMentions() {
        return AllowedMentions.none().withParseEveryone(this.getAllowedMentions().users()).withParseRoles(this.getAllowedMentions().roles()).withParseUsers(this.getAllowedMentions().everyone());
    }
}

