/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.AbstractConfigurationNode;
import org.spongepowered.configurate.CommentedConfigurationNodeIntermediary;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;

abstract class AbstractCommentedConfigurationNode<N extends CommentedConfigurationNodeIntermediary<N>, A extends AbstractCommentedConfigurationNode<N, A>>
extends AbstractConfigurationNode<N, A>
implements CommentedConfigurationNodeIntermediary<N> {
    protected static final AtomicReferenceFieldUpdater<AbstractCommentedConfigurationNode, String> COMMENT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AbstractCommentedConfigurationNode.class, String.class, "comment");
    protected volatile @Nullable String comment;

    protected AbstractCommentedConfigurationNode(@Nullable A parent, A copyOf) {
        super(parent, copyOf);
    }

    protected AbstractCommentedConfigurationNode(@Nullable Object key, @Nullable A parent, @NonNull ConfigurationOptions options) {
        super(key, parent, options);
    }

    @Override
    public @Nullable String comment() {
        return this.comment;
    }

    @Override
    public N comment(@Nullable String comment) {
        if (!Objects.equals(COMMENT_UPDATER.getAndSet(this, comment), comment)) {
            this.attachIfNecessary();
        }
        return (N)((CommentedConfigurationNodeIntermediary)this.self());
    }

    @Override
    public N commentIfAbsent(String comment) {
        if (COMMENT_UPDATER.compareAndSet(this, null, comment)) {
            this.attachIfNecessary();
        }
        return (N)((CommentedConfigurationNodeIntermediary)this.self());
    }

    @Override
    public N from(ConfigurationNode that) {
        String otherComment;
        if (that instanceof CommentedConfigurationNodeIntermediary && (otherComment = ((CommentedConfigurationNodeIntermediary)that).comment()) != null) {
            this.comment(otherComment);
        }
        return (N)((CommentedConfigurationNodeIntermediary)super.from(that));
    }

    @Override
    public N mergeFrom(ConfigurationNode other) {
        String otherComment;
        if (other instanceof CommentedConfigurationNodeIntermediary && (otherComment = ((CommentedConfigurationNodeIntermediary)other).comment()) != null) {
            this.commentIfAbsent(otherComment);
        }
        return (N)((CommentedConfigurationNodeIntermediary)super.mergeFrom(other));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractCommentedConfigurationNode)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractCommentedConfigurationNode that = (AbstractCommentedConfigurationNode)o;
        return Objects.equals(this.comment, that.comment);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.comment);
        return result;
    }
}

