/*
 * Decompiled with CFR 0.152.
 */
package me.anutley.dislink.common.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import me.anutley.dislink.common.DisLink;
import me.anutley.dislink.common.config.ChannelsConfig;
import me.anutley.dislink.common.config.GlobalSettingsConfig;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.loader.ConfigurationLoader;

public class ConfigLoader {
    private final DisLink disLink;
    private ConfigurationNode originalGlobalSettingsNode;
    private ConfigurationNode globalSettingsNode;
    private ConfigurationNode originalChannelNode;
    private ConfigurationNode channelNode;

    public ConfigLoader(DisLink disLink) {
        this.disLink = disLink;
    }

    public ConfigurationLoader<?> configurationLoader(String fileName) {
        return ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().file(new File(this.disLink.dataFolder(), fileName))).prettyPrinting(true).build();
    }

    public <T> T load(Class<T> configClass, String fileName) {
        if (!Files.exists(this.disLink.dataFolder().toPath(), new LinkOption[0])) {
            try {
                Files.createDirectories(this.disLink.dataFolder().toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ConfigurationLoader<?> loader = this.configurationLoader(fileName);
        try {
            Object originalNode = loader.load();
            ConfigurationNode configNode = originalNode.copy();
            if (configClass.equals(GlobalSettingsConfig.class)) {
                this.globalSettingsNode = configNode;
                this.originalGlobalSettingsNode = originalNode;
            }
            if (configClass.equals(ChannelsConfig.class)) {
                this.channelNode = configNode;
                this.originalChannelNode = originalNode;
            }
            T config = configNode.get(configClass);
            if (!Files.exists(new File(this.disLink.dataFolder(), fileName).toPath(), new LinkOption[0])) {
                configNode.set(configClass, config);
                loader.save(configNode);
            }
            return config;
        }
        catch (ConfigurateException exception) {
            this.disLink.logger().error("There was an error loading the config file", exception);
            return null;
        }
    }

    public void reloadMainConfig(Class<?> clazz, String fileName) {
        this.load(clazz, fileName);
    }

    public <V> void saveConfig(String fileName, ConfigurationNode configNode, Class<?> clazz, V config) {
        try {
            this.configurationLoader(fileName).save(configNode.set(clazz, (Object)config));
        }
        catch (ConfigurateException e) {
            throw new RuntimeException(e);
        }
        this.reloadMainConfig(clazz, fileName);
    }

    public ConfigurationNode originalGlobalSettingsNode() {
        return this.originalGlobalSettingsNode;
    }

    public ConfigurationNode globalSettingsNode() {
        return this.globalSettingsNode;
    }

    public ConfigurationNode originalChannelNode() {
        return this.originalChannelNode;
    }

    public ConfigurationNode channelNode() {
        return this.channelNode;
    }
}

