/*
 * Decompiled with CFR 0.152.
 */
package me.anutley.dislink.common.delivery.sender;

import java.util.concurrent.CompletableFuture;
import me.anutley.dislink.common.DisLink;
import me.anutley.dislink.common.config.ChannelPairConfig;
import me.anutley.dislink.common.delivery.message.DisLinkPlainTextMessageBuilder;
import me.anutley.dislink.common.delivery.sender.MessageSender;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.exceptions.ErrorResponseException;
import net.dv8tion.jda.api.utils.messages.MessageEditData;

public class PlainTextSender
extends MessageSender<JDA, DisLinkPlainTextMessageBuilder> {
    public PlainTextSender(DisLink disLink, ChannelPairConfig pairConfig, ChannelPairConfig.ChannelConfig originChannel, ChannelPairConfig.ChannelConfig destinationChannel, Message message) {
        super(disLink, pairConfig, originChannel, destinationChannel, message);
    }

    @Override
    public CompletableFuture<JDA> prepare() {
        return this.message.getAuthor().getId().equals(this.disLink.jda().getSelfUser().getId()) ? CompletableFuture.completedFuture(null) : CompletableFuture.completedFuture(this.disLink.jda());
    }

    @Override
    public Long send(JDA deliveryMethod, DisLinkPlainTextMessageBuilder messageBuilder) throws ErrorResponseException {
        return ((Message)this.destinationChannel().sendMessage(messageBuilder.build()).complete()).getIdLong();
    }

    @Override
    public void edit(JDA deliveryMethod, long messageId, DisLinkPlainTextMessageBuilder messageBuilder) {
        this.destinationChannel().editMessageById(messageId, MessageEditData.fromCreateData(messageBuilder.build())).submit().thenApplyAsync(ISnowflake::getIdLong);
    }

    @Override
    public DisLinkPlainTextMessageBuilder newMessageBuilder() {
        return new DisLinkPlainTextMessageBuilder(this);
    }

    @Override
    public String messageSettingKey() {
        return "messages.plaintext.message-format";
    }
}

