/*
 * Decompiled with CFR 0.152.
 */
package me.anutley.dislink.common.util;

import java.util.Optional;
import me.anutley.dislink.common.DisLink;
import me.anutley.dislink.common.config.ChannelPairConfig;
import org.spongepowered.configurate.ConfigurationNode;

public class SettingsUtil {
    private final DisLink disLink;

    public SettingsUtil(DisLink disLink) {
        this.disLink = disLink;
    }

    private ConfigurationNode getSetting(ChannelPairConfig channelPair, String setting) {
        ConfigurationNode node;
        ConfigurationNode originalChannelsNode = this.disLink.configLoader().originalChannelNode();
        ConfigurationNode globalSettingsNode = this.disLink.configLoader().originalGlobalSettingsNode();
        Optional<ConfigurationNode> channelNodeOptional = originalChannelsNode.node("channels").childrenList().stream().filter(channel -> {
            String firstChannel = channel.node("first-channel").node("channel-id").getString();
            String secondChannel = channel.node("second-channel").node("channel-id").getString();
            if (firstChannel == null || secondChannel == null) {
                return false;
            }
            return channelPair.firstChannel().channelId().equals(firstChannel) && channelPair.secondChannel().channelId().equals(secondChannel);
        }).findFirst();
        Object[] settings = setting.split("\\.");
        if (channelNodeOptional.isPresent() && !(node = channelNodeOptional.get().node("channel-settings").node(settings)).virtual()) {
            return node;
        }
        return globalSettingsNode.node("global-settings").node(settings).virtual() ? this.disLink.configLoader().globalSettingsNode().node("global-settings").node(settings) : globalSettingsNode.node("global-settings").node(settings);
    }

    public String getString(ChannelPairConfig channelPair, String setting) {
        return this.getSetting(channelPair, setting).getString();
    }

    public boolean getBoolean(ChannelPairConfig channelPair, String setting) {
        return this.getSetting(channelPair, setting).getBoolean();
    }
}

