/*
 * Decompiled with CFR 0.152.
 */
package me.anutley.dislink.common.delivery.sender;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.anutley.dislink.common.DisLink;
import me.anutley.dislink.common.config.ChannelPairConfig;
import me.anutley.dislink.common.delivery.message.DisLinkMessageBuilder;
import me.anutley.dislink.common.delivery.message.mentions.AllowedMentionsBuilder;
import me.anutley.dislink.common.util.StringUtil;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.unions.GuildMessageChannelUnion;
import net.dv8tion.jda.api.utils.SplitUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MessageSender<D, M extends DisLinkMessageBuilder<?>> {
    public final DisLink disLink;
    public final ChannelPairConfig pairConfig;
    protected final ChannelPairConfig.ChannelConfig originChannel;
    protected final ChannelPairConfig.ChannelConfig destinationChannel;
    protected final Message message;

    public MessageSender(DisLink disLink, ChannelPairConfig pairConfig, ChannelPairConfig.ChannelConfig originChannel, ChannelPairConfig.ChannelConfig destinationChannel, Message message) {
        this.disLink = disLink;
        this.pairConfig = pairConfig;
        this.originChannel = originChannel;
        this.destinationChannel = destinationChannel;
        this.message = message;
    }

    @Nullable
    public abstract CompletableFuture<D> prepare();

    public abstract Long send(D var1, M var2) throws Exception;

    public abstract void edit(D var1, long var2, M var4);

    public abstract M newMessageBuilder();

    public abstract String messageSettingKey();

    @NotNull
    public GuildMessageChannelUnion originChannel() {
        return Objects.requireNonNull(this.disLink.jda().getChannelById(GuildMessageChannelUnion.class, this.originChannel.channelId()));
    }

    @NotNull
    public GuildMessageChannelUnion destinationChannel() {
        return Objects.requireNonNull(this.disLink.jda().getChannelById(GuildMessageChannelUnion.class, this.destinationChannel.channelId()));
    }

    public void execute() {
        CompletableFuture<D> prepareFuture = this.prepare();
        if (prepareFuture == null) {
            return;
        }
        ((CompletableFuture)prepareFuture.whenCompleteAsync((d, throwable) -> {
            List<String> messages;
            if (d == null) {
                this.disLink.debug("For some reason this message delivery type is null, please report this on DisLink's GitHub/Discord server");
                return;
            }
            try {
                messages = this.getMessagesSplit(this.getPlaceholderReplacedMessage(this.messageSettingKey()), SplitUtil.Strategy.WHITESPACE);
            }
            catch (IllegalStateException exception) {
                messages = this.getMessagesSplit(this.getPlaceholderReplacedMessage(this.messageSettingKey()), SplitUtil.Strategy.ANYWHERE);
            }
            if (StringUtil.isEmpty(this.message.getContentRaw()) && this.message.getEmbeds().isEmpty()) {
                this.sendOnlyFiles(d);
                return;
            }
            M messageBuilder = this.newMessageBuilder();
            for (int i = 0; i < messages.size(); ++i) {
                long messageId;
                if (i != messages.size() - 1) {
                    ((DisLinkMessageBuilder)messageBuilder).content(messages.get(i));
                    try {
                        this.send(d, messageBuilder);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!StringUtil.isEmpty(this.message.getContentRaw())) {
                    ((DisLinkMessageBuilder)messageBuilder).content(messages.get(i));
                }
                if (this.getEmbeds() != null) {
                    this.getEmbeds().forEach(arg_0 -> messageBuilder.addEmbed(arg_0));
                }
                try {
                    messageId = this.send(d, messageBuilder);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.editAttachments(messageBuilder, d, messageId);
            }
            if (throwable != null) {
                this.disLink.logger().error("Error while preparing the message delivery type ", (Throwable)throwable);
            }
        })).whenCompleteAsync((m, e) -> e.printStackTrace());
    }

    private void sendOnlyFiles(D deliveryMethod) {
        long messageId;
        M messageBuilder = this.newMessageBuilder();
        ((DisLinkMessageBuilder)messageBuilder).content("\u200b");
        try {
            messageId = this.send(deliveryMethod, messageBuilder);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.editAttachments(this.newMessageBuilder(), deliveryMethod, messageId);
    }

    private void editAttachments(M messageBuilder, D deliveryMethod, long messageId) {
        AtomicReference attachments = new AtomicReference(new HashMap());
        if (this.getAttachments().isEmpty()) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            for (int j = 0; j < this.getAttachments().size(); ++j) {
                Message.Attachment attachment = this.getAttachments().get(j);
                try {
                    ((Map)attachments.get()).computeIfAbsent(attachment.getFileName(), k -> new ArrayList()).add(attachment.getProxy().download().get());
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }).whenCompleteAsync((ignored, error) -> {
            ((Map)attachments.get()).forEach((name, inputStreams) -> inputStreams.forEach(inputStream2 -> messageBuilder.addFile((String)name, (InputStream)inputStream2)));
            this.edit(deliveryMethod, messageId, messageBuilder);
            error.printStackTrace();
        });
    }

    public AllowedMentionsBuilder getAllowedMentions() {
        return new AllowedMentionsBuilder(this.disLink.settingsUtil().getBoolean(this.pairConfig, "mentions.everyone"), this.disLink.settingsUtil().getBoolean(this.pairConfig, "mentions.role"), this.disLink.settingsUtil().getBoolean(this.pairConfig, "mentions.user"));
    }

    protected List<MessageEmbed> getEmbeds() {
        if (this.disLink.settingsUtil().getBoolean(this.pairConfig, "ignore.embeds")) {
            if (!this.message.getEmbeds().isEmpty()) {
                this.disLink.debug("Embeds in the original message were found, but are not being forwarded due to being ignored");
            }
            return null;
        }
        return this.message.getEmbeds();
    }

    protected List<Message.Attachment> getAttachments() {
        if (this.disLink.settingsUtil().getBoolean(this.pairConfig, "ignore.attachments")) {
            if (!this.message.getAttachments().isEmpty()) {
                this.disLink.debug("Attachments in the original message were found, but are not being forwarded due to being ignored");
            }
            return Collections.emptyList();
        }
        return new ArrayList<Message.Attachment>(this.message.getAttachments());
    }

    public List<String> getMessagesSplit(String formattedMessage, SplitUtil.Strategy strategy) throws IllegalStateException {
        return SplitUtil.split(formattedMessage, 2000, strategy);
    }

    public String getPlaceholderReplacedMessage(String settingKey) {
        return this.replaceDefaultMessagePlaceholders(this.disLink.settingsUtil().getString(this.pairConfig, settingKey));
    }

    protected String replaceDefaultMessagePlaceholders(String format) {
        User author = this.message.getAuthor();
        format = format.replaceAll("%author_username%", author.getName()).replaceAll("%author_displayname%", author.getGlobalName() != null ? author.getGlobalName() : author.getName()).replaceAll("%author_id%", author.getId()).replaceAll("%author_avatar%", author.getEffectiveAvatarUrl()).replaceAll("%author_mention%", author.getAsMention());
        Member member = this.message.getMember();
        boolean memberNull = member == null;
        Role topRole = null;
        if (!memberNull) {
            try {
                topRole = member.getRoles().get(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        format = format.replaceAll("%author_nickname%", memberNull ? author.getName() : member.getEffectiveName()).replaceAll("%author_guild_avatar%", memberNull ? author.getEffectiveAvatarUrl() : member.getEffectiveAvatarUrl()).replaceAll("%author_toprole_name%", topRole == null ? "" : topRole.getName()).replaceAll("%author_toprole_mention%", topRole == null ? "" : topRole.getAsMention());
        format = this.replaceChannelPlaceholders(format, "origin", this.originChannel());
        format = this.replaceChannelPlaceholders(format, "destination", this.destinationChannel());
        format = this.replaceGuildPlaceholders(format, "origin", this.originChannel());
        format = this.replaceGuildPlaceholders(format, "destination", this.destinationChannel());
        format = format.replaceAll("%message%", Matcher.quoteReplacement(this.message.getContentRaw()));
        Matcher match = Pattern.compile("%.+%").matcher(format);
        if (match.find()) {
            this.disLink.debug("There is an invalid placeholder in the format \"" + format + "\"");
        }
        return format;
    }

    public String replaceChannelPlaceholders(String format, String prefix, GuildChannel channel) {
        return format.replaceAll("%" + prefix + "_channel_name%", channel.getName()).replaceAll("%" + prefix + "_channel_id%", channel.getId()).replaceAll("%" + prefix + "_channel_mention%", channel.getAsMention());
    }

    public String replaceGuildPlaceholders(String format, String prefix, GuildChannel channel) {
        String guildIcon = channel.getGuild().getIconUrl();
        return format.replaceAll("%" + prefix + "_guild_name%", channel.getGuild().getName()).replaceAll("%" + prefix + "_guild_id%", channel.getGuild().getId()).replaceAll("%" + prefix + "_guild_iconurl%", guildIcon == null ? "" : guildIcon);
    }

    public static enum Type {
        WEBHOOK,
        PLAINTEXT;

    }
}

