/*
 * Decompiled with CFR 0.152.
 */
package me.anutley.dislink.common.listener;

import java.util.HashMap;
import java.util.Map;
import me.anutley.dislink.common.DisLink;
import me.anutley.dislink.common.config.ChannelPairConfig;
import me.anutley.dislink.common.delivery.sender.MessageSender;
import me.anutley.dislink.common.delivery.sender.PlainTextSender;
import me.anutley.dislink.common.delivery.sender.WebhookSender;
import net.dv8tion.jda.api.entities.channel.unions.GuildMessageChannelUnion;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;

public class MessageListener
extends ListenerAdapter {
    private final DisLink disLink;

    public MessageListener(DisLink disLink) {
        this.disLink = disLink;
    }

    @Override
    public void onMessageReceived(MessageReceivedEvent event) {
        if (!event.isFromGuild()) {
            return;
        }
        this.getDestinationChannels(event.getGuildChannel()).forEach((channelPair, destinationChannel) -> {
            if (this.invalidAuthor((ChannelPairConfig)channelPair, event)) {
                return;
            }
            ChannelPairConfig.ChannelConfig originChannel = channelPair.firstChannel().channelId().equals(destinationChannel.channelId()) ? channelPair.secondChannel() : channelPair.firstChannel();
            MessageSender delivery = channelPair.type().equals((Object)MessageSender.Type.WEBHOOK) ? new WebhookSender(this.disLink, (ChannelPairConfig)channelPair, originChannel, (ChannelPairConfig.ChannelConfig)destinationChannel, event.getMessage()) : new PlainTextSender(this.disLink, (ChannelPairConfig)channelPair, originChannel, (ChannelPairConfig.ChannelConfig)destinationChannel, event.getMessage());
            delivery.execute();
        });
    }

    private Map<ChannelPairConfig, ChannelPairConfig.ChannelConfig> getDestinationChannels(GuildMessageChannelUnion channel) {
        String originChannelId = channel.getId();
        HashMap<ChannelPairConfig, ChannelPairConfig.ChannelConfig> channels = new HashMap<ChannelPairConfig, ChannelPairConfig.ChannelConfig>();
        for (ChannelPairConfig pairConfig : this.disLink.configManager().channelsConfig().channels()) {
            ChannelPairConfig.ChannelConfig firstChannel = pairConfig.firstChannel();
            ChannelPairConfig.ChannelConfig secondChannel = pairConfig.secondChannel();
            ChannelPairConfig.Direction direction = pairConfig.direction();
            String firstChannelId = firstChannel.channelId();
            String secondChannelId = secondChannel.channelId();
            if (!originChannelId.equals(firstChannelId) && !originChannelId.equals(secondChannelId)) continue;
            if (this.disLink.jda().getGuildChannelById(firstChannelId) == null) {
                this.disLink.debug("A message has been sent in a channel listen in the config, however the destination channel (" + firstChannelId + ") doesn't exist ");
                continue;
            }
            if (this.disLink.jda().getGuildChannelById(secondChannelId) == null) {
                this.disLink.debug("A message has been sent in a channel listen in the config, however the destination channel (" + secondChannelId + ") doesn't exist ");
                continue;
            }
            if (originChannelId.equals(firstChannelId) && (direction.equals((Object)ChannelPairConfig.Direction.BOTH) || direction.equals((Object)ChannelPairConfig.Direction.FIRST_TO_SECOND))) {
                channels.put(pairConfig, secondChannel);
            }
            if (!originChannelId.equals(secondChannelId) || !direction.equals((Object)ChannelPairConfig.Direction.BOTH) && !direction.equals((Object)ChannelPairConfig.Direction.SECOND_TO_FIRST)) continue;
            channels.put(pairConfig, firstChannel);
        }
        return channels;
    }

    private boolean invalidAuthor(ChannelPairConfig channelPair, MessageReceivedEvent event) {
        boolean ignoreBots = this.disLink.settingsUtil().getBoolean(channelPair, "ignore.bots");
        boolean ignoreWebhooks = this.disLink.settingsUtil().getBoolean(channelPair, "ignore.webhooks");
        if (event.getAuthor().isBot() && !event.isWebhookMessage() && ignoreBots) {
            this.disLink.debug("The author of this message is a bot, and ignore bots is enabled in the config, aborting message forwarding for " + event.getMessage());
            return true;
        }
        if (event.isWebhookMessage() && ignoreWebhooks) {
            this.disLink.debug("The author of this message is a webhook, and ignore webhooks is enabled in the config, aborting message forwarding for " + event.getMessage());
            return true;
        }
        return false;
    }
}

